# An Overview of Qualitative Research and Focus Group Discussion

Seçil Tümen Akyıldız1 Fırat University, Elazığ, Turkey

Kwestan Hussein AHMED2 Fırat University, Elazığ, Turkey

# Abstract

Recently, qualitative studies have been widespread in various areas such as psychology, business, and sociology. In this review, the process of qualitative study has been clarified to offer a description of its general process. Basically, the qualitative investigation is exploratory, which indicates an understanding of the results made by the researcher(s). Likewise, designing research is a process or guideline utilized to prepare, implement, and evaluate an idea that the researchers want to reveal about an issue. It is also a plan to answer the problems or concepts of an investigated study. Since qualitative studies help researchers to examine opinions, attitudes, and perspectives of human beings, so it has gained more attention in many fields and especially in the area of social sciences. Accordingly, the qualitative study focuses on how individuals perceive and give meaning to different social behaviors in order to explore people’s social observations. This study aims to reveal the qualitative research process and how the data would be collected via this approach. The researchers attempt to announce the significance of the qualitative study and focus group discussion tool (advantages and limitations as well) to propose a better understanding for the academics who want to utilize a qualitative study in social sciences.

Submitted 22 January 2021

Revised 25 April 2021

Accepted 07 May 2021

Keywords: Qualitative research, Focus group discussion, Social Sciences

# Suggested Citation:

Tümen-Akyıldız, S., & Ahmed, K.H. (2021). An overview of qualitative research and focus group discussion. Journal of Academic Research in Education, 7(1), 1-15. DOI: 10.17985/ijare.866762

# INTRODUCTION

In the last few decades, the utilization of the qualitative approach has grown in several fields. It may be utilized to investigate a variety of aspects of social interaction for the progress of society. Qualitative research provides descriptive or literary explanations of the hypothesis under the study. When a researcher wants a much more descriptive interpretation, then a qualitative technique could be chosen. It offers a richer and better understanding of society under investigation (Mohajan, 2018). Each study needs to demand a specific, organized, structured method to discover more effective outcomes. Qualitative research is related to nature, and the researcher typically investigates the interpretations and perspectives of a particular environment (Corbin & Strauss, 2014; Levitt et al., 2017). It is also a kind of study that emphasizes the way people interpret and create meaning of their perception in recognizing the social context (Zohrabi, 2013). Similarly, Creswell (2009) claimed a qualitative study as a successful model that exists in a realistic context and allows the investigator to establish a degree of depth information from a group of participants in a specific profession (Creswell, 2009). It applies to a variety of data processing and interpretation methods that are used for a purpose of interviewing, semi-structured, and open-ended group discussions (Dudwick et al., 2006). The discussion interviews are one of the advanced forms of interpersonal interaction for a particular objective, referring to any accepted chosen topic (Anderson et al., 1998). So, the research interview aims to achieve the interviewee’s study-related facts, it focuses on the obtained documentation for the research purposes of expecting, clarifying or describing, the specific issues (Cohen, 2007). In qualitative studies, the interview approach is very valuable and significant as they illustrate comprehensive as well as a systematic analysis of the event or condition through nature. (Fraenkel & Wallen, 2003).

A crucial step for conducting a qualitative study is that the researchers should think about a tool for collecting data and analyzing techniques. There are various methods for collecting data in qualitative research, but choosing which method is related to what the researcher exactly wants to achieve. This study aimed to announce the significance of the qualitative study, and focus group discussion tool (advantages and limitations) to suggest a better understanding for researchers who want to utilize a qualitative study in the field of social sciences.

# 1. Qualitative research

Qualitative research is an investigation into how members of the discussion perceive a particular social issue. Typically, it includes interviews or discussions that generate non-numeric results. If a researcher tries to realize an individual’s views or opinions, statistics (quantitative research) does not provide a complete view. Conversations or discussions with individuals (qualitative research) sometimes enable investigators to achieve more understanding about why and what are the individuals’ perceptions about the research topic (Manu, 2018). Similarly, Lauri 2019 claimed that qualitative research is a fundamental factor for understanding certain hypotheses. Although quantitative data help explain the prevalence of attitudes and behavior, qualitative data also may seek to clarify and describe the causes that influencing behavioral perspectives. (Lauri, 2019). Likewise, the qualitative study aims to advance and improve the perception of how issues are handled in a social circumstance (Hancock et al., 2001).

Recently qualitative research has developed and gained interest in the social fields because it attempts to create a detailed explanation of human attitudes, feelings, and perceptions (Tong et al., 2012). Qualitative research is known as an umbrella that is utilized for applying scientific frameworks such as phenomenology, narrative, action research, grounded theory, case study, content analysis, historical study, and ethnography (Creswell & Poth, 2016; Hancock et al., 2001).

Scholars have suggested different definitions for qualitative research studies, e.g., Strauss and Corbin (1990) defined qualitative research as, any kind of study that produces results not based on quantitative approaches or different forms of measurements. This can contribute to work on an individual’s life, personal observations, attitudes, perceptions, and opinions (Strauss & Corbin, 1990). Also, Flick 2018 defined it as the understanding and formulation of textual or verbal content to create claims about the clear and ambiguous aspects. The processes of creating meaning in the content and what is represented inside it (Flick, 2018, p 420). On the other hand, Mohajan (2018) claimed it as a successful design that exists in a natural context and allows the investigator to acquire information from a high level of involvement in specific professions. It is commonly used in social sciences for non-numerical statistics and tries to explain the significance of these data to help researchers analyze social activity through the sample of specific populations or areas (Mohajan, 2018). Furthermore, Van Maanen (1979) has welldefined qualitative research as an umbrella term for incorporating a variety of interpretational techniques that seek to describe, interpret, decode the issues in the social sciences. So, according to the aforementioned definitions by different scholars, qualitative research is recognized as a significant aspect for revealing problems and issues in social sciences.

In qualitative research, researchers try to reveal the conditions in that behaviors occur. Unlike quantitative one, qualitative research focuses on understanding complex human issues rather than generalize the results to large populations (Vanderstoep & Johnston, 2009). Selecting the proper sample has an important effect on the quality of the research (Joyne, 1997). Therefore, qualitative sampling needs to be addressed to ensure trustworthiness. There are two general ways of sampling in qualitative research namely: random and non-random. Random sampling is meant to select participants from a group having equal chance to attend a study (Vanderstoep & Johnston, 2009). Researchers usually utilize three non-random sampling models in qualitative research. They are convenience, purposeful and theoretical samples (Oppong, 2013). Convenience samples involve people available for study. It is an easy way to recruit participants although the results obtained may not be generalizable to the larger population (Vanderstoep & Johnston, 2009). Marshall (1996) also indicated that research using convenience sampling is less credible due to its being less demanding and the possibility of acquiring poor data. Purposeful samples are selected people having knowledge and experience about the research interest (Creswell &Plano Clark, 2011). Theoretical samples, on the other hand, are the people selected to examine a theory and then a new sample group to test the theory’s validity (Marshall, 1996). Besides selecting proper sample methods there are other issues to contribute to the trustworthiness of qualitative research. Guba (1981) defined four criteria to meet the trustworthiness of qualitative research namely: credibility, transferability, dependability and confirmability. Researchers should try to find the answer of ‘how congruent are the findings with reality?’ to meet the credibility criterion (Merriam, 1998). Shenton (2004) declared that triangulation of data, background of the researcher, willingness of participants, and giving direct quotations are the ways to ensure credibility. Transferability is a kind of external validity which means the results of a study are applicable to others (Merriam, 1998). Dependability is reliability which means in case the research question is re-examined under the same conditions, the similar findings will be achieved (Shenton, 2004). Confirmability is the last criterion of trustworthiness which can be met by triangulation of data and necessary to reduce the researcher’s bias (Shenton, 2004).

Commonly in qualitative studies, the researchers use codes and interpretations which are utilized by researchers’ brain but currently, the progressive of computer software for analyzing data makes the work easier than before. Especially when the data are big for the researcher to manage very well. Although some computer software such as SPSS and SAS have been programmed for quantitative data, other computer programs can be handled for analyzing non-numerical data, such as survey questions, focus group discussion interviews, interview transcripts, and online interviews. The most common programs for qualitative research in social sciences, including NVivo (Hilal & Alabri, 2013), QDA Miner, and QDA Miner Lite, MAXQDA, and ATLAS.ti (Crossman, 2020).

# 1.1. The advantages of qualitative research

# 1.1.1. Realizing a detailed description of an issue

For complex problems, common numbers can indicate what happens to that problem, but not why it happens. In this case, qualitative studies are valuable for examining and describing social dynamics in detail. As an example, quantitative facts can examine how lots of females dope out from school, but qualitative facts can help investigators to understand the obstacles that make their parents drop them out of school. So, this would be more powerful to investigate the detailed barriers behind the issue. (Manu, 2018).

# 1.1.2. To improve research questions

When a researcher decides to conduct a study, s/he may just have an idea of how and what needs to collect the data, and by using qualitative research may realize the problem and enable the investigator to make a design for future studies (Manu, 2018). In other words, qualitative research attempts to have relevant and deeper explanations of the questions that the investigator asks the participants. Therefore, it tends to obtain an efficient understanding that might be potentially neglected in another method (Hossain, 2011). Moreover, qualitative studies are formed to investigate “how” and “why” not just “when”, “what”, and “where” issues happen, in this regard qualitative need a small number of participants but more focused compared to large randomly selected participants (Hossain, 2011; Murphy et al., 1998).

# 1.1.3. To know a group of participant’s perspectives

To explain the study question or subject from the perspective of a specific group of participants. Likewise, it is particularly useful for gathering specific knowledge on the beliefs, views, attitudes, perspectives, and social contextual factors of particular groups of people (Med & AFMS, 1997). Thus, it allows the researcher to examine the inner perception of participants, and find out how concepts are formed in society (Corbin & Strauss, 2008).

# 1.1.4. To simplify complicated issues

The qualitative study designs have a variable structure as the framework can be created and reproduced to a better range (Maxwell, 2012). For this purpose, a detailed and effective study of the problem may be conducted by using qualitative study approaches and thus the members would have enough confidence to decide the appropriate and inappropriate things. Consequently, complicated problems or issues could be more efficiently interpreted (Flick, 2011).

# 1.1.5. To achieve more subjective and detailed data

Investigators communicate openly with the members involved via interviews. The most common methods that are used for collecting data in qualitative research such as focus group discussions, participant-observation, direct observation, unstructured interviews, and describing records throughout collecting the data. So, the outcomes of the data would be subjective and informative (Rahman, 2020).

# 2. Qualitative research process

Researching whether qualitative or quantitative needs a well-developed plan and some essential steps to reveal what the researcher wishes to investigate of an issue and collecting data. So, writing a study is just like going on a trip if one doesn’t know the path s/he has to use a map, yet if one knows the path there is no need to access a map. Accordingly investigating an issue or a problem requires some significant steps to write more efficiently. Likewise, the research process needs to be clear about what the researcher wants to realize and what questions s/he wants to discover their answer. Therefore, some essential steps should be emphasized in order to make the work easier. Figure 1. shows the research process steps (Kumar, 2018).

At the beginning of the research process, the researcher should think of choosing a topic and then conducts a public search on the topic to find out more in literature review and what is in the field that the researcher plans to write about. Then, finding a certain class of people is a significant step to get knowledge about their perceptions and opinions related to the topic issue. Thus, the researcher seeks to focus on collecting knowledge and understand the participant’s perspectives about the issue (Creswell et al., 2016). In the next step, a number of questions are prepared for the discussion (Cohen & Crabtree, 2006). Research questions play a vital role in conducting a qualitative study. Therefore, the questions require some necessities like clear, easy to search, and understandable (Bryman, 2016; Morse, 1994; Pole & Lampard, 2002). Similarly, Maxwell (2012) argued that a common problem will arise if there is not a relationship between the research questions and the research goals. So, the questions of the research should be designed very carefully (Maxwell, 2012). Then s/he has to choose a method for the research via interviews, questionnaires, focus group discussion, or in-depth interviews. After collecting data, the investigator starts to collect and analyze the obtained data, and analyzing the data is also considered as another significant step in a qualitative study. So, determining appropriate methods and techniques should be planned carefully (Leech& Onwuegbuzie, 2007). Accordingly, the researcher may interpret and compare his or her work with earlier works in the field. Finally, the conclusion should be based on the outcomes of the study, as well as some recommendations for future studies can be added at the end of the study (Lincoln, 2005).

![](images/245852d4a3e5931280e013ee5ff21febee145dd701245d5115d06123df94ff36.jpg)  
Figure 1. Research process from Shah (2017) and Kumar (2018).

# 3. The Methods of Collecting data in Qualitative Studies

There are various methods for gathering data in a qualitative study, but choosing which one is related to what the researcher exactly wants to achieve. The most common tools used for qualitative research are focus group discussions, interviews, and participant observation (Vanderstoep & Johnston, 2009). Recently focus group discussion as a tool for collecting data in qualitative studies has been expanded in many fields (Krueger & Casey, 2000; Madriz, 2000; Morgan, 1996). In this study, as the qualitative research method focus group discussion has been highlighted.

Social science investigators in general and qualitative investigators especially depend on focus groups to obtain data from several people at the same time. Focus groups might be more confident in certain study subjects, and this kind of discussion is beneficial for participants to reveal beliefs, opinions, perspectives, and experiences (Onwuegbuzie et al., 2009).

# 3.1. Focus group discussion

Interviews as very popular tools of qualitative research are believed to provide a deeper insight of a phenomenon when very little is known about it. They are very proper especially when the participants do not want to talk about some sensitive issues in a group environment (Gill, Stewart, Treasure & Chadwick, 2008). FGDs on the other hand, are more advantageous providing more authentic environments in which participants influence one another and are influenced (Casey & Crueger, 2000). Group interaction is the other advantage creating synergy effect on participants (Stewart & Shamdasani, (2014). Moreover, when there is limited opportunity for data collection focus groups are preferably compared to individual interviews (Vanderstoep & Johnston, 2009). Therefore, they are utilized to collect high-quality data in the social context as Patton (2002) emphasized. Then FGDs should be defined and understood well to conduct them properly.

Initially, the focus groups were used and clarified by Bogadus in 1926 in the field of social sciences (Rice & Ezzy, 1999). It is also known as the most commonly widespread technique in social sciences. It has appeared as a recognizable element of the qualitative research group of cognitive and scientific research for a specific purpose (Stewart & Shamdasani, 2014). FGDs are recognized as not limited interviews facilitated by a professional moderator. The moderator raises open-ended questions to achieve answers and stimulates debate among the members involved. The objective of the moderator in a focus group discussion is to produce the greatest number of arguments and perspectives within a limited duration. This method might be used as the researcher wants to explain a problem or issue at a deeper understanding than a questionnaire method. (Prasad & Garcia, 2017).

Dilshad & Latif (2013) claimed that a focus group interview has been one of the significant gathering techniques in qualitative research (Dilshad & Latif, 2013). Also, to conduct a number of a particular discussion, focus groups would be a reasonable one for collecting data. Choosing participants for a focus group is not random, thus for achieving good group conformation some tips should be planned very well. However, if the subject is not simple, Krueger (1994) acclaimed that the researcher should not have more than 7 members in the focus group (Casey& Krueger, 1994; Vanderstoep & Johnson, 2008). Furthermore, as explained by Casey & Krueger (2000), the focus group offers a more ordinary environment to compare with individual interviews. The participants are affected by peers much as if they are in reality (Krueger & Casey, 2000). Moreover, required participants often enjoy communicating with each other, and the discussion will create different ideas and perspectives for both participants and the researcher as well (Cameron, 2005). So a focus group discussion would be a useful attempt to have participants with common experiences together to examine a particular subject of interest, and it is known as an effective way to gather knowledge from all kinds of people (i.e. young age children & teens, and elderly adults as well) (Lune& Berg, 2017)

Compared with other collecting data techniques such as questionnaires, observations, and so on, group discussions can be a valuable source to explore the internal views and emotions of individuals, interviewing with participants is highly suitable for knowing because it focused on feelings, thoughts, perceptions, sensitive matters, experiences, and knowledge of the members (Wisker, 2001).

Some dos and don’ts need to be done when a researcher tries to conduct an FGDs, for example, the moderator should listen to all participants and, s/he has to ask general and open-ended questions to get the participant wormed up; as the discussion gets started s/he must tell all the discussion rules and make them feel confident enough; and the moderator should be sympathetic about the arise subject (Adelmund, 2007). Besides, some don’ts should be mentioned such as the moderator should not ask yesno questions; do not tell any of the participants that you are wrong; and the moderator should not dismiss any comments or opinions by the participants even if it doesn’t similar to moderator’s opinion (Adelmund, 2007). Accordingly, the moderator and the members should be respectful to each other to make sure that everyone expresses their perspectives. Furthermore, shaking the head or raising eyebrows, accepting or rejecting suggestions, as well, are not allowed in focus group discussion (Smithson, 2008).

Currently using the internet has extended everyone’s life. There are 679.7 million people in the world who are accessing internet technology. This development has led to an intense educational interest in the social implications of the use of computers, specifically in the use of computers by individuals and groups to have meetings and make decisions without the need for face-to-face meetings such as online focus group discussions (Reid & Reid, 2005; Reid et al., 1996).

# 3.2. Some significant steps for conducting focus group discussion

Figure 2 shows a schematic diagram that provides the steps of conducting focus group discussion. In the qualitative research method (focus group discussion), a researcher gathers some participants for discussing a selected topic that has a common interest to both the researcher and the participants (Morgan, 1997). In performing the analysis, the researcher should plan the purpose of the focus group in his mind. The results will be achieved quickly after the closing of the group meeting. Verifying audio records, examining written letters, gathering, labeling auxiliary resources, the great concepts and ideas are required in focus group data collection (Anderson et al., 1998).

Krueger 2014 indicated that the focus group must have a moderator for presiding the focus group meeting. The responsibilities of the moderator are initiating the debate, as well as inspiring participants to respond for expressing their perceptions and opinions confidently. Another, crucial role of the moderator is to make members assure and comfortable to be engaged with the discussion effectively. Furthermore, everyone should be able to speak and interact (Krueger, 2014). The technique for recruiting participants would depend on the kind of participants that the researcher needs.

A significant point to conduct a focus group is the creation of the basic rules. One of the basic rules includes privacy, and this requires planning for a proposal carefully, and the implementation stage of the ethics committee. For implementing focus groups, the researcher should think about a topic and an issue. Indeed, FGDs need to obtain a group of specific members who should have experience with the target topic for the interview discussions. Thus, the chosen respondents must have enough information to debate the subject of the discussion (Richardson & Rabiee, 2001). The number of the participants of the focus groups may differ, commonly focus group members consists of 10-12 people (Baumgartner et al., 2002) between six to ten (Powell & Single, 1996) and between six to eight (Krueger & Casey, 2000), together in a discussion which they will guide by a moderator. The variety of focus group sizes comes from the target that focus groups can involve appropriate members to produce various information offered. Accordingly, focus groups should not be involved with too many participants as large groups otherwise it doesn’t construct a confident environment for the participants for expressing their views, viewpoints, values, and skills (Onwuegbuzie et al., 2009). The research issue and the research layouts have essentially controlled how the focus group is developed. Well-organized focus groups usually run from one to two hours (Morgan, 1996).

On the other hand, Dawson et al. emphasized some management for collecting focus group discussion data and they insist on writing notes by pen and paper carefully which makes the study more trustworthy. Accordingly, they recommended some key points to collect data such as recording the discussion to do not miss any comments or opinions by the participants; preparing the information for analysis; and storing the information for the time if the researcher needs them to review (Dawson et al., 1993). At the end of the discussion, the researcher(s) analyze the session and collect the data for the study (Cameron, 2010; Focus Groups, 2017).

![](images/08ed5929e2178ef516c87503efd8013afb6ea335eae723723139931f6e015600.jpg)  
Figure 2. Steps to conduct a focus group retrieved from (Focus Groups, 2017).

Besides, Anderson et al. (1998) also recommended some tips for data collection in the focus group discussion.

 The researcher should type and record the name of participants and their comments as well, and s/he should be careful about the arrangement of seating of the members.   
 In the content analysis, the researcher should cut significant comments and paste the remarks into subjects.   
 All the comments and grammatical mistakes should be arranged and edited when needed.   
 For all statements separately a summary statement should be written (Anderson et al., 1998).

# 3.3 Advantages and limitations of the focus group in qualitative research

# 3.3.1 Advantages of conducting focus groups

As compared to other techniques focus group discussion has some advantages and limitations that need to be addressed as follows:

1. Focus groups are a fast, effective, and economic method for gathering information with a group of well-organized participants in a socially-oriented environment (Onwuegbuzie et al., 2009).   
2. Interaction is a fundamental characteristic in the focus groups interaction among stakeholders reveals everyone’s perspective, the language discussion, their beliefs, and values about the topic. Regularly, interaction allows individuals to discuss issues with each other and re-examine their understandings about their experiences (Kitzinger, 1994, 1995).   
3. The focus group discussion tool has a variety of interesting properties that are useful for distance learning (Tümen Akyıldız, 2020).   
4. A large amount of information can be achieved much rapidly and at fewer coasts with the focus group compared to the other conventional interviews.   
5. They are extremely good at accessing data from social groups.   
6. When the focus group is being applied to discuss comparatively small problems, individuals who are not qualified in observational analysis techniques can quickly handle it.   
7. Since the open-ended questions are flexible, it assumes that the researcher can reveal perceptions and beliefs which may not be discovered in the questionnaire.   
8. The investigator is in the session at such discussions can pursue answers when needed.   
9. It’s also accepted, and enjoyable by the participants (Dawson et al., 1993).

# 3.3.2 Limitations of the focus group discussions

Above and beyond the benefits and significance of using a focus group, some limitations need to be emphasized in conducting a focus group.

1. Focus group findings may not commonly be used to create assumptions about the larger population, in other words, but results also may reflect a variety of views and beliefs, nevertheless not their distributions.   
2. Group members often accept the answers of the discussion participants’, as well as caution is always necessary for evaluating the findings.   
3. An untrained moderator may simply force the members to respond to issues in a specific way that he wants not the participant’s opinion (Dawson et al., 1993) Similarly, Gibbs (1997) claimed that the moderator should let the participants negotiate with each other, express and ask about different opinions or doubts, whereas unknowledgeable moderator may not control the discussion in a proper way (Gibbs, 1997).

4. There is a limitation to explore the complex ideas of individuals, so in-depth, discussions are a more suitable approach for this aim.

5. It may create a picture of what is commonly in natural culture rather than what happens or is accepted. The researcher has to be aware of choosing what kind of participants and must have good skills to moderate the discussion (Dawson et al., 1993; Dilshad et al., 2013; Gorman et al., 2005).

# 3.4. Analyzing focus group data

Onwuegbuzie et al. (2009) and Leech and Onwuegbuzie (2007, 2008) recommended a helpful framework that contains several qualitative analyzing techniques for researchers. The analytical techniques that are effective to analyze focus group data such as; constant comparison method, content analysis, keywordsin-context, and discourse analysis.

# 3.4.1. Constant comparison analysis

Although this method first advanced by Glaser and Strauss 1967 which was used in grounded theory research (Glaser& Strauss, 1967), then Leech and Onwuegbuzie (2007, 2008) had discovered that constant comparison may be helpful to analyze other types of data such as focus group discussion (Leech& Onwuegbuzie, 2008; Onwuegbuzie & Collins, 2007; Onwuegbuzie et al., 2009). It may include a comparison of subjects occurring in diverse focus groups. In order to establish more complete features of the categories for the individual codes, the researcher should constantly compare the categories and codes of new texts with current categories and codes. This is an ongoing process before quantity is attained (Barnett, 2002).

Generally, the data can be interpreted via constant comparison once the researchers would have decided to have more than one focus group. This technique helps the researcher to measure saturation and especially saturation across groups (Charmaz, 2000).

# 3.4.2. Content analysis

Content analysis is a research technique utilized to assess the meaning of given patterns, words, or perceptions in a certain obtained data. The data can be gained via interviews, focus groups, open-ended questions, and conversations. This technique is most commonly used in the qualitative study which aims to divide the content of the discussion into an appropriate number of categories that express the same meaning (Moretti et al., 2011). Accordingly, creating content codes of the discussion and taking care of the repeated codes are crucial points. Although the content analysis in some ways is similar to t constant comparison. The constant comparison makes a theme with the codes while content analysis tries to count and place the codes into equal groupings (Onwuegbuzie et al., 2009). The current content analysis applications display three distinctive approaches which it is directed, conventional, or it is summative. These approaches are needed to interpret the meaning of the content of the text data; therefore, they observe the natural paradigm. The origin of the codes, coding structures, and challenges to reliability are the main variations among the approaches (Hsieh & Shannon, 2005). In addition, Weber (1990) claimed that qualitative content analysis is going from purely counting words to systematically analyzing vocabulary to categorize large amounts of the document into an effective number of categories for describing related concepts (Weber, 1990). Concerning the analysis of the data, researchers may use quantitative data analysis to present statistical or mathematical results using tools, while a qualitative researcher can use content analysis to analyze meaning or to evaluate their results based on description or written outcomes (Zakaria & Zakaria, 2016).

# 3.4.3. Keywords-in-context

Keywords-in-context is a kind of analysis used in numerous fields. Researchers using the keywords-incontext, utilize words differently by analyzing the meaning of the word in their expression (Leech et al., 2008). This technique requires a detailed examination of the meaning of language and words as a context in both individual and group discussions. It is clearly reflecting an interpretation of the context in using the word. This technique aims to evaluate the utilization of words in context with other words (Onwuegbuzie et al., 2009). Although several software applications such as (QSR International Pty Ltd., 2006, and NVIVO, version 7.0) are available and can be used to facilitate with keywords-in-context analyzing technique, theycan be also carried out manually (Leech et al., 2008; Richards, 1999).

# 3.4.4. Discourse analysis

Discourse analysis is a scientific research technique for analyzing spoken or written language about its social meaning. Its objective is to explain how languages are used in practical life settings. Commonly it is used qualitative studies in the field of social sciences. Accordingly, it is a conceptual way to analyze documents, depending on both essentials of the content given as well as on conceptual experience, that the researcher creates interpretations. It focused on the objectives and impacts of various language types, and how the use of language refers to its historical, social, and political meaning (Luo, 2020).

In Britain, a group of social psychologists leading by Potter and Wetherall formed a method of discourse analysis which is also recognized as discursive psychology. They proposed that in addition to recognizing human behavior and perception, it was important to investigate how individuals interacted in everyday conditions (Potter & Wetherell, 1987). This qualitative research technique requires the selection of specific, unique sections or language usage elements like numerous lines of focus group discussion texts. After that, it will be analyzed to observe how forms of elements like community, skills, procedures, and society develop in discourse (Jorgensen & Phillips, 2002). Ultimately, this concept corresponds to wellestablished approaches for explaining and recognizing things (Leech et al., 2008).

# 4. Views of researchers about the importance of focus group discussion in social science studies

If focus group discussion has been recognized as a beneficial method for researchers of other fields in general, it has multiple advantages for social science researchers (Krueger, R. A. et al., 2000). This part shows the view of researchers whom they conducted their study via focus group discussions. González & Quinchía, (2003) researched EFL teachers’ perceptions to analyze the testimony of private and publicschool teachers, owing to the importance of group discussion for such a kind of studies they used four focus session to reveal how participants believe and feel about the project (González & Quinchía, 2003).

Consequently, Tümen Akyıldız, (2020) conducted research to know college students’ views on the pandemic distance education. She conducted the study via the focus group discussion technique and she mentioned it as a significant method because it is unlike personal interviews. The participants could think openly in focus group conversations and feeling confident to express what they believe, share arguments with others, and modify their personal views as the conversation continues in informal life situations. She also claimed that the focus group discussion tool has a variety of interesting properties that are useful for distance learning. Similarly, Toland et al., (2014) conducted a qualitative study and focus group session to collect data due to the significant role of this method for understanding opinions and ideas of several stakeholders, including faculty members, administrators, and students, at private Japanese university concerning their usage and perceptions of the LMS Manaba. They realized that the focus group is more suitable for collecting their data. Accordingly, they claimed that there are many advantages that led them to use a focus group as a collecting tool and stated it as a powerful tool for collecting data (Toland et al., 2014). Furthermore, Lobe et al., claimed that qualitative researchers face new prospects and obstacles in the period of COVID19 (a pandemic period of coronavirus disease which raised in 2019), and the remote learning situation, they highlighted the significance of qualitative research and focus group for this pandemic situation. They also revealed several alternative tools for collecting data during the socially distant process which is instead of collecting data via face to face the researchers can collect their data via online focus group discussion (Lobe et al., 2020). Likewise, collecting data via online platforms has become increasing in the field of social sciences, so to enhance and perhaps a replacement of face-toface interactions online focus groups are utilized progressively (Lobe, 2017). In addition to the important focus group in qualitative and social science Tercanlioglu (2008) examined an investigation of pre-service English as a foreign language (EFL) teacher opinions which the researcher used focus group discussion through the significance of focus groups and aims at gathering the widest variety of knowledge (Tercanlioglu, 2008).

# CONCLUSION

This study aimed to highlight the importance of qualitative research and as a tool focus group discussion in social sciences. The investigation revealed that qualitative studies can help the investigators to examine and achieve the explanation of complex concepts. As qualitative research deals with human behaviors and thoughts, it can be seen as an easier method for conducting than quantitative research. The process of conducting qualitative research and focus group discussion can be more collaborative compared to other types of research because focus group discussion inspires a framework for stakeholders and give them a chance to express their feelings and opinions as well thanks to the group synergy. Furthermore, the researchers should have a well-planned purpose and some key steps should be mentioned to implement this method for being more effective and successful study.

# References

Adelmund, L. (2007 May 9). Dos and Don’ts for a Positive Focus Group Experience. from https://www.foliomag.com/dos-and-donts-positive-focus-group-experience/   
Anderson, G., Anderson, G. J., & Arsenault, N. (1998). Fundamentals of educational research: Psychology Press.   
Barnett, J. M. (2002). Focus groups tips for beginners. Texas Centre for adult literacy & learning.   
Baumgartner, T., Strong, C., & Hensley, L. (2002). Measurement issues in research. Conducting and Reading Research in Health and Human Performance, McGraw-Hill, New York, NY, 329-350.   
Bryman, A. (2016). Social Research Methods.   
Cameron, J. (2005). Focusing on the focus group.   
Cameron, J. (2010). Focusing on the focus group. Qualitative research methods in human geography, 3, 152-172.   
Casey, M., & Krueger, R. (1994). Focus group interviewing Measurement of food preferences (pp. 77-96): Springer.   
Charmaz, K. (2000). Grounded theory: Objectivist and constructivist methods. Handbook of qualitative research, 2, 509-535.   
Cohen, D., & Crabtree, B. (2006). Qualitative research guidelines project.   
Cohen, L. (2007). Experiments, quasi-experiments, single-case research and meta-analysis (Cohen, L., Manion, L., & Morrison, K. in Eds) Research methods in education. (6th eds.): London: Routledge Falmer.   
Corbin, J., & Strauss, A. (2008). Memos and diagrams. Basics of Qualitative Research 3e. London: Sage, 117-141.   
Corbin, J., & Strauss, A. (2014). Basics of qualitative research: Techniques and procedures for developing grounded theory: Sage publications.   
Creswell, J. W. (2009). RESEARCH DESIGN.   
Creswell, J. W., & Poth, C. N. (2016). Qualitative inquiry and research design: Choosing among five approaches: Sage publications.   
Crossman, A. (2020, August 27). These Software Tools Can Help You Analyze Qualitative Data. from Retrieved from https://www.thoughtco.com/analyze-qualitative-data-software-3026538   
Dawson, S., Manderson, L., & Tallo, V. L. (1993). A manual for the use of focus groups: Boston: international Nutrition foundation for developing countries.   
Dilshad, R. M., & Latif, M. I. (2013). Focus Group Interview as a Tool for Qualitative Research: An Analysis. Pakistan Journal of Social Sciences (PJSS), 33(1).   
Dudwick, N., Kuehnast, K., Jones, V. N., & Woolcock, M. (2006). Analyzing social capital in context. A guide to using qualitative methods and data, 1-46.   
Flick, U. (2011). A beginner’s guide to doing a research project. Introducing Research.   
Flick, U. (2018). An introduction to qualitative research: Sage Publications Limited.   
Fraenkel, J. R., & Wallen, N. E. (2003). Student workbook to accompany how to design and evaluate research in education: McGraw-Hill.   
Gibbs, A. (1997). Focus groups. Social research update, 19(8), 1-8.   
Gill, P., Stewart, K., Treasure, E. & Chadwick, B. (2008). Methods of data collection in qualitative research: interviews and focus groups. British Dental Journal, 204 (6), 291-295.   
Glaser, B., & Strauss, A. (1967). The discovery of grounded theory Aldine Publishing Company. Hawthorne, NY.   
González Moncada, A., & Quinchía Ortiz B, D. I. (2003). Tomorrow's EFL teacher educators. Colombian Applied Linguistics Journal (5), 86-104.   
Gorman, G. E., Clayton, P. R., Shep, S. J., & Clayton, A. (2005). Qualitative research for the information professional: A practical handbook: Facet Publishing.   
Guba, E. G. (1981). Criteria for assessing the trustworthiness of naturalistic inquiries. Educational Communication and Technology Journal, 29, 75–91   
Focus Groups (2017, April 18). Focus on Focus Groups. from http://www.getresearchpower.com/news/2017/4/18/focus-on-focus-groups   
Hancock, B., Ockleford, E., & Windridge, K. (2001). An introduction to qualitative research: Trent focus group.   
Hilal, A. H., & Alabri, S. S. (2013). Using NVivo for data analysis in qualitative research. International interdisciplinary journal of education, 2(2), 181-186.   
Hossain, D. M. (2011). Qualitative research process. Postmodern Openings, 2(7), 143-156.   
Hsieh, H.-F., & Shannon, S. E. (2005). Three approaches to qualitative content analysis. Qualitative health research, 15(9), 1277-1288.   
Jorgensen, M. W., & Phillips, L. J. (2002). Discourse analysis as theory and method: Sage.   
Joyne, I. (1997). Sampling in Qualitative Research. Purposeful and Theoretical Sampling; Merging or Clear Boundaries? Journal of Advanced Nursing, 26 (3), 623-630.   
Kitzinger, J. (1994). The methodology of focus groups: the importance of interaction between research participants. Sociology of health & illness, 16(1), 103-121.   
Kitzinger, J. (1995). Qualitative research: introducing focus groups. Bmj, 311(7000), 299-302.   
Krueger, R., & Casey, M. (2000). Focus Groups: A Practical Guide for Applied Research 3rd Edition Sage Publications London.   
Krueger, R. A. (2014). Focus groups: A practical guide for applied research: Sage publications.   
Krueger, R. A., & Casey, M. A. (2000). A practical guide for applied research. A practical guide for applied research.   
Kumar, R. (2018). Research methodology: A step-by-step guide for beginners: Sage.   
Lauri, M. A. (2019). WASP (Write a Scientific Paper): Collecting qualitative data using focus groups. Early human development, 133, 65-68.   
Leech, N. L., & Onwuegbuzie, A. J. (2007). An array of qualitative data analysis tools: A call for data analysis triangulation. School psychology quarterly, 22(4), 557.   
Leech, N. L., & Onwuegbuzie, A. J. (2008). Qualitative data analysis: A compendium of techniques and a framework for selection for school psychology research and beyond. School psychology quarterly, 23(4), 587.   
Levitt, H. M., Motulsky, S. L., Wertz, F. J., Morrow, S. L., & Ponterotto, J. G. (2017). Recommendations for designing and reviewing qualitative research in psychology: Promoting methodological integrity. Qualitative psychology, 4(1), 2.   
Lincoln, N. K. D. Y. S. (2005). The Sage handbook of qualitative research: Sage.   
Lobe, B. (2017). Best Practices for Synchronous Online Focus Groups. In A New Era in Focus Group Research (pp. 227-250): Springer.   
Lobe, B., Morgan, D., & Hoffman, K. A. (2020). Qualitative data collection in an era of social distancing. International journal of qualitative methods, 19, 1609406920937875.   
Lune, H., & Berg, B. L. (2017). Qualitative research methods for the social sciences: Pearson.   
Luo, A. (2020 June 19). What is discourse analysis? from https://www.scribbr.com/methodology/discourseanalysis/#:\~:text=Discourse%20analysis%20is%20a%20research,of%20different%20types%20of%2 0language   
Madriz, E. (2000). Focus groups in feminist research. In N. K. Denzin & Y. S. Lincoln (Eds.), Handbook of qualitative research (2nd ed., pp. 835–850).   
Manu, B. (2018 March 26). 3 Qualitative Research Methods You Should Know. from https://humansofdata.atlan.com/2018/03/3-qualitative-research-methods/   
Marshall, M. N. (1996). Sampling for qualitative research. Family Practice, 13(6), 522-525.   
Maxwell, J. A. (2012). Qualitative research design: An interactive approach (Vol. 41): Sage publications.   
Med, S. A. C., & AFMS, E. D. (1997). Qualitative research.   
Mohajan, H. K. (2018). Qualitative research methodology in social sciences and related subjects. Journal of Economic Development, Environment and People, 7(1), 23-48.   
Moretti, F., van Vliet, L., Bensing, J., Deledda, G., Mazzi, M., Rimondini, M., . . . Fletcher, I. (2011). A standardized approach to qualitative content analysis of focus group discussions from different countries. Patient education and counseling, 82(3), 420-428.   
Morgan, D. L. (1996). Focus groups as qualitative research (Vol. 16): Sage publications.   
Morgan, D. L. (1997). The focus group guidebook (Vol. 1): Sage publications.   
Morse, J. M. (1994). Critical issues in qualitative research methods: Sage.   
Murphy, E., Dingwall, R., Greatbatch, D., Parker, S., & Watson, P. (1998). Qualitative research methods in health technology assessment: a review of the literature.   
Onwuegbuzie, A. J., & Collins, K. M. (2007). A typology of mixed methods sampling designs in social science research. Qualitative Report, 12(2), 281-316.   
Onwuegbuzie, A. J., Dickinson, W. B., Leech, N. L., & Zoran, A. G. (2009). A qualitative framework for collecting and analyzing data in focus group research. International journal of qualitative methods, 8(3), 1-21.   
Oppong, S. H. (2013). The problem of sampling in qualitative research. Asian Journal of Management Sciences and Education,2 (2), 202-210.   
Patton, M.Q. (2002). Qualitative evaluation and research methods. (3rd ed.). Thousand Oaks, CA: Sage.   
Pole, C. J., & Lampard, R. (2002). Practical social investigation: Qualitative and quantitative methods in social research: Pearson Education.   
Potter, J., & Wetherell, M. (1987). Discourse and social psychology: Beyond attitudes and behaviour: Sage.   
Powell, R. A., & Single, H. M. (1996). Focus groups. International journal for quality in health care, $g ( 5 )$ , 499-504.   
Prasad, M., & Garcia, C. (2017 September 11). How to Conduct a Successful Focus Group Discussion. from https://humansofdata.atlan.com/2017/09/conduct-successful-focus-group-discussion/   
Rahman, M. S. (2020). The advantages and disadvantages of using qualitative and quantitative approaches and methods in language “testing and assessment” research: A literature review.   
Reid, D. J., & Reid, F. J. (2005). Online focus groups: An in-depth comparison of computer-mediated and conventional focus group discussions. International journal of market research, 47(2), 131-162.   
Reid, F. J., Malinek, V., Stott, C. J., & Evans, J. S. B. (1996). The messaging threshold in computer-mediated communication. Ergonomics, 39(8), 1017-1037.   
Rice, P. L., & Ezzy, D. (1999). Qualitative research methods: A health focus (Vol. 720): Oxford Victoria, Australia.   
Richards, L. (1999). Using NVivo in qualitative research: Sage.   
Richardson, C. A., & Rabiee, F. (2001). A question of access: an exploration of the factors that influence the health of young males aged 15 to 19 living in Corby and their use of health care services. Health education journal, 60(1), 3-16.   
Shah, P. (2017 June 18). Research Process as Circular from https://profparesh.in/research-process-ascircular/   
Shenton, A. K. (2004). Strategies for ensuring trustworthiness in qualitative research projects. Education for Information, 22, 63–75.   
Smithson, J. (2008). Focus groups. The Sage handbook of social research methods, 357-370.   
Stewart, D. W., & Shamdasani, P. N. (2014). Focus groups: Theory and practices. Newbury Park: Sage.   
Strauss, A., & Corbin, J. (1990). Basics of qualitative research: Sage publications.   
Tercanlioglu, L. (2008). A Qualitative Investigation of Pre-Service English as a Foreign Language (EFL) Teacher Opinions. Qualitative Report, 13(1), 137-150.   
Toland, S., White, J., Mills, D., & Bolliger, D. U. (2014). EFL instructors' perceptions of usefulness and ease of use of the LMS Manaba. JALT CALL Journal, 10(3), 221-236.   
Tong, A., Flemming, K., McInnes, E., Oliver, S., & Craig, J. (2012). Enhancing transparency in reporting the synthesis of qualitative research: ENTREQ. BMC medical research methodology, 12(1), 181.   
Tümen Akyıldız, S. (2020). College students’ views on the pandemic distance education: A focus group discussion. International Journal of Technology in Education and Science, 4(4), 322-334.   
Van Maanen, J. (1979). Reclaiming qualitative methods for organizational research: A preface. Administrative science quarterly, 24(4), 520-526.   
Vanderstoep, S. W., & Johnson, D. D. (2008). Research methods for everyday life: Blending qualitative and quantitative approaches (Vol. 32): John Wiley & Sons.   
Weber, R. P. (1990). Basic content analysis: Sage.   
Wisker, G. (2001). Sylvia Plath: Hodder & Stoughton.   
Zakaria, N., & Zakaria, N. (2016). Qualitative content analysis: A paradigm shift from manual coding to computer-assisted coding using ATLAS. ti: SAGE Publications, Ltd.   
Zohrabi, M. (2013). Mixed Method Research: Instruments, Validity, Reliability and Reporting Findings. Theory & practice in language studies, 3(2).